import { Http, IParam, RouteUtil } from '@core';
/**
 * 实体服务基类
 * @export
 * @class EntityService
 */
export class EntityService {

  /**
   * 应用上下文
   *
   * @protected
   * @type {*}
   * @memberof EntityService
   */
  protected context: any;

  /**
   *  实体关系路径集合
   *
   * @protected
   * @type {any[]}
   * @memberof EntityService
   */
  protected deResPaths: any[] = []

  /**
   * HTTP服务类
   *
   * @protected
   * @memberof EntityService
   */
  protected http = Http.getInstance();

  /**
   * Creates an instance of EntityService.
   * @param {IParam} [opts] 应用上下文
   * @param {string} [dbName] 本地存储表
   * @param {(0 | 1 | 3)} [storageMode] 存储模式
   * @memberof EntityService
   */
  constructor(opts: IParam = {}, dbName?: string, storageMode?: 0 | 1 | 3) {
    this.context = opts;
  }

  /**
   *  计算请求的实体关系路径
   *
   * @protected
   * @param {*} context 视图上下文
   * @param {boolean} isSelfAppend 是否拼接实体自身的主键值
   * @return {*} 
   * @memberof EntityService
   */
  protected buildDeResPath(context: any, isSelfAppend: boolean) {
    let deResPath = RouteUtil.buildDeResRequestPath(context, this.deResPaths);
    // 不需要自身的主键值的删除末尾/xxxx
    if (!isSelfAppend) {
      deResPath = deResPath.substring(0, deResPath.lastIndexOf("/"))
    }
    return deResPath;
  }

}